/*
 * Copyright 2021-2022 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.opentest4j.reporting.cli;

import org.opentest4j.reporting.tooling.converter.DefaultConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine.Command;
import picocli.CommandLine.Parameters;

import java.nio.file.Path;
import java.util.concurrent.Callable;

/**
 * Converts from the event-based to the hierarchical XML format.
 */
@Command(name = "convert", description = "Converts from the event-based to the hierarchical XML format")
public class ConvertCommand implements Callable<Integer> {

	private static final Logger LOG = LoggerFactory.getLogger(ConvertCommand.class);

	@Parameters(arity = "1")
	Path eventsXml;

	@Override
	public Integer call() throws Exception {
		var targetFile = eventsXml.resolveSibling("hierarchy.xml");
		var converter = new DefaultConverter();
		converter.convert(eventsXml, targetFile);
		LOG.info("Converted {} to {}", eventsXml, targetFile);
		return 0;
	}
}
